// $Id: HNSSortedTableView.m,v 1.1.1.1 2003/01/05 22:08:48 hns Exp $
//
//  HNSSortedTableView.m
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Wed Jul 03 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//
// todo:
//	autoSaveName -> sorted column&order
//	change table column for sorting by clicking into header
//	show arrows showing direction
//	enable/disable sort oder change by user

#import "HNSAppKit/HNSSortedTableView.h"

@interface NSTableView (Default)

// define hidden interface
+ (NSImage *) _defaultTableHeaderSortImage;
+ (NSImage *) _defaultTableHeaderReverseSortImage;
- (void)_sendAction:(SEL) action to:(id) target row:(int) r column:(int) c;

@end

@interface HNSSortedTableView (PrivateExtensions)

- (void) sort;
#if 0
- (void) click;
- (void) doubleClick;
#endif

@end

@implementation HNSSortedTableView

// overridden core methods

- (void) awakeFromNib
{ // does not call init if loaded from NIB!
#if 0
	NSLog(@"[%@ awakeFromNib]\n", self);
#endif
	// needs to override addColumn to add this action as well
	index=NULL;						// no index yet
	isize=-1;						// size of allocated index, i.e. none
	sortCol=-1;						// sorting column
	backwards=NO;					// sorting order
	[super setDataSource: self];	// I am the data source - to translate
							        // for all header cells: setAction:selector(headerClick:) and setTarget:self
		                            // this will trigger the first reloadData/sort
	[self setSortColumn:0 descending:NO];			// and start with first
	[self setAllowsColumnSelection:YES];
//	[super setTarget:self];	// intercept table clicks
//	[super setAction:@selector(click:)];
//	[super setDoubleAction:@selector(doubleClick:)];
						   // other initial code
#if 0
	[super awakeFromNib];	// does not exist in superview
#endif
}

- (id) initWithFrame:(NSRect) f
	{
#if 0
	NSLog(@"[NSSortedTableView initWithFrame]\n");
#endif
	self=[super initWithFrame:f];	// init table
	if(self)
		{
		index=NULL;						// no index
		isize=-1;						// size of allocated index, i.e. none
		sortCol=-1;						// sorting column
		backwards=NO;					// sorting order
		[super setDataSource: self];	// I am the data source - to translate
		[self setSortColumn:0 descending:NO];			// and start with first
		[self setAllowsColumnSelection:YES];
//		[super setTarget:self];	// intercept table clicks
//		[super setAction:@selector(click:)];
//		[super setDoubleAction:@selector(doubleClick:)];
		}
	return self;
}

#if 0
- (void)forwardInvocation:(NSInvocation *)invocation
{ // unrecognized selector
    if ([tableView respondsToSelector:[invocation selector]])
        [invocation invokeWithTarget:tableView];
    else
        [self doesNotRecognizeSelector:[invocation selector]];
}
#endif

- (void) dealloc
{
	free(index);
	[dataSource release];
	[super dealloc];
}

// new methods

- (void) setSortColumn:(int) col descending:(BOOL) flag
{ // -1 or otherwise invalid: don't sort
	if(col == sortCol && flag == backwards)
		return;	// no change
	if(col != sortCol && sortCol >= 0 && sortCol < [[self tableColumns] count])
		{ // deselect icon (if column is visible)
		[super setIndicatorImage:nil inTableColumn:[[self tableColumns] objectAtIndex:sortCol]];
		}
	sortCol=col;	// set new
	backwards=flag;
	if(col >= 0 && col < [[self tableColumns] count])
		{ // change icon (if column is visible)
		NSTableColumn *c=[[self tableColumns] objectAtIndex:col];
		[self deselectColumn:col];
		[self setIndicatorImage:flag?
[NSTableView _defaultTableHeaderReverseSortImage]:
[NSTableView _defaultTableHeaderSortImage] inTableColumn:c];
		[self setHighlightedTableColumn:c];
		}
	[self reloadData];	// needs to reload
}

- (void) reloadData
{ // needs to rebuild index
	free(index);
	index=NULL;
	isize=-1;			// refresh index and sort if required
	[super reloadData];	// needs to reload
}

- (int) sortColumn
{
	return sortCol;
}

- (BOOL) isSortingAscending
{
	return !backwards;
}

- (BOOL) isSortingDescending
{
	return backwards;
}

#if 0
- (void) doubleClick:(id) sender
{
#if 0
	NSLog(@"doubleClick: col=%d row=%d selcol=%d selrow=%d", [super clickedColumn], [super clickedRow], [super selectedColumn], [super selectedRow]);
#endif
	[target performSelector:doubleAction withObject:sender];
}

- (void) click:(id) sender
{ // method to handle clicks into header
	// check if sort by user enabled
	int col=[super selectedColumn]; // determine column
#if 0
	NSLog(@"click: col=%d row=%d selcol=%d selrow=%d", [super clickedColumn], [super clickedRow], [super selectedColumn], [super selectedRow]);
#endif
	if(col < 0 || [super clickedRow] >= 0)
		{
		[target performSelector:action withObject:sender];
		return;
		}
	if(sortCol != col)
		[self setSortColumn:col descending:backwards];	// same direction in other column
	else
		[self setSortColumn:col descending:!backwards];	// other direction in same column
}

#endif

// internal interface for quicksort

static id data;
static NSTableColumn *aTableColumn;
static NSTableView *t;

static int comparASC(const void *a, const void *b)
{ // compare two values through index array
	NSString *d1, *d2;	// also works for all objects that specify the compare: selector
	d1=[data tableView:t objectValueForTableColumn:aTableColumn row:*(int *) a];
	if(!d1)
		return NSOrderedAscending;	// nil entry
	d2=[data tableView:t objectValueForTableColumn:aTableColumn row:*(int *) b];
	return (int) [d1 compare:d2]; // return values are NSOrderedDescending etc. but seem to match qsort requirements
}

static int comparDESC(const void *a, const void *b)
{ // compare two values through index array
	NSString *d1, *d2;	// also works for all objects that specify the compare: selector
	d1=[data tableView:t objectValueForTableColumn:aTableColumn row:*(int *) a];
	if(!d1)
		return NSOrderedDescending;	// nil entry
	d2=[data tableView:t objectValueForTableColumn:aTableColumn row:*(int *) b];
	return (int) -[d1 compare:d2]; // return values are NSOrderedDescending etc. but seem to match qsort requirements
}

- (void) sort
{
	unsigned i;
#if 0
	NSLog(@"[HNSSortedTableView sort] entries=%d col=%d backwards=%d table=%@\n", isize, sortCol, backwards, self);
#endif
	for(i=0; i<isize; i++)
		index[i]=i;		// start unsorted
	if(sortCol < 0 || sortCol >= [[self tableColumns] count])
		return;	// don't sort at all
	aTableColumn=[[self tableColumns] objectAtIndex:sortCol];	// initialize global parameters for compar
	data=dataSource;
	t=self;
	qsort(index, isize, sizeof(index[0]), backwards?comparDESC:comparASC);	// and sort
#if 0
	NSLog(@"[HNSSortedTableView sort] index: %d, %d, %d, ...", index[0], index[1], index[2]);	// print some index values
#endif
}

- (int) table2data:(int) rowIndex
{
#if 0
	NSLog(@"table2data:%d", rowIndex);
#endif
	if(rowIndex < 0 || rowIndex >= isize)
		return rowIndex;
	return index[rowIndex];	// translate
}

- (int) data2table:(int) rowIndex
{ // search
	int i;
#if 0
	NSLog(@"data2table:%d", rowIndex);
#endif
	for(i=0; i<isize; i++)
		if(index[i] == rowIndex)
			return i;
	return rowIndex;	// not found
}

// overridden methods

- (id) dataSource
{
	return dataSource;
}

- (void) setDataSource:(id) s
{
#if 0
	NSLog(@"[%@ setDataSource:%@]", self, s);
#endif
	[dataSource autorelease];
	dataSource=[s retain];
}

- (void)_sendAction:(SEL) action to:(id) target row:(int) r column:(int) c
{ // intercept click and double click
#if 0
	NSLog(@"[%@ _sendAction: to:%@ row:%d column:%d]", self, target, r, c);
#endif
	if(r == -1)
		{ // click onto header
		if(action == [self action])
			{ // single click
			if(sortCol != c)
				[self setSortColumn:c descending:backwards];	// same direction in other column
			else
				[self setSortColumn:c descending:!backwards];	// other direction in same column
			}
		// pass through double click
		}
	[super _sendAction:action to:target row:r column:c];
}

#if 0
- (void)mouseDown:(NSEvent *)theEvent
{
	target=[self target];
	action=[self action];
	doubleAction=[self doubleAction];
	[self setTarget:self];	// mouseDown uses [self target] to issue action
	[self setAction:@selector(click:)];
	[self setDoubleAction:@selector(doubleClick:)];
	[super mouseDown:theEvent];
	[self setTarget:target];
	[self setAction:action];	// restore
	[self setDoubleAction:doubleAction];
}

- (id) target
{
	return target;
}

- (void) setTarget:(id) t
{
#if 0
	NSLog(@"[%@ setTarget:%@]", self, t);
#endif
	[target autorelease];
	target=[t retain];
}

- (SEL) action
{
	return action;
}

- (void) setAction:(SEL) a
{
#if 0
	NSLog(@"[%@ setAction:%@]", self, NSStringFromSelector(a));
#endif
	action=a;
}

- (SEL) doubleAction
{
	return doubleAction;
}

- (void) setDoubleAction:(SEL) a
{
	doubleAction=a;
}
#endif

// interface methods called by [super dataSource]

- (int) numberOfRowsInTableView:(NSTableView *)aTableView
{
	int n=[dataSource numberOfRowsInTableView:aTableView];
	NSParameterAssert(aTableView == self);
	if(n != isize)
		{ // index size has changed
#if 0
		NSLog(@"index size changed from %ld to %ld\n", isize, n);
#endif
		isize=n;
		index=realloc(index, sizeof(*index)*isize);	// (re)allocate index as needed
		[self sort];			// needs (re) sorting
		}
	return n;
}

- (id) tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	NSParameterAssert(aTableView == self);
	return [dataSource tableView:aTableView objectValueForTableColumn:aTableColumn row:[self table2data:rowIndex]];	// go through index
}

- (void) tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	NSParameterAssert(aTableView == self);
	return [dataSource tableView:aTableView setObjectValue:anObject forTableColumn:aTableColumn row:[self table2data:rowIndex]];	// go through index
}

// translate other methods, i.e. clickRow, selectedRow etc.

// return data row

- (int)clickedDataRow
{
	return [self table2data:[super clickedRow]];
}

- (int)editedDataRow
{
	return [self table2data:[super editedRow]];
}

- (int)dataRowAtPoint:(NSPoint)aPoint
{
	return [self table2data:[super rowAtPoint:aPoint]];
}

- (int)selectedDataRow
{
	return [self table2data:[super selectedRow]];
}

// pass data row

- (void)deselectDataRow:(int)rowIndex
{
	[super deselectRow:[self data2table:rowIndex]];
}

- (void)drawDataRow:(int)rowIndex clipRect:(NSRect)clipRect
{
	[super drawRow:[self data2table:rowIndex] clipRect:clipRect];
}

- (void)editColumn:(int)columnIndex dataRow:(int)rowIndex withEvent:(NSEvent *)theEvent select:(BOOL)flag
{
	[super editColumn:columnIndex row:[self data2table:rowIndex] withEvent:theEvent select:flag];
}

- (NSRect)frameOfCellAtColumn:(int)columnIndex dataRow:(int)rowIndex
{
	return [super frameOfCellAtColumn:columnIndex row:[self data2table:rowIndex]];
}

- (NSRect)rectOfDataRow:(int)rowIndex
{
	return [super rectOfRow:[self data2table:rowIndex]];
}

- (void)setDropDataRow:(int)row dropOperation:(NSTableViewDropOperation)operation
{
	return [super setDropRow:[self data2table:row] dropOperation:operation];
}

- (NSEnumerator *)selectedDataRowEnumerator
{
	[NSException raise:@"NSInternalInconsistency" format:@"[HNSSortedTableView selectedDataRowEnumerator] not implemented"]; // internal error
	return nil;
}

- (BOOL)isDataRowSelected:(int)rowIndex
{
	return [super isRowSelected:[self data2table:rowIndex]];
}

- (void)scrollDataRowToVisible:(int)rowIndex
{
	return [super scrollRowToVisible:[self data2table:rowIndex]];
}

- (void)selectDataRow:(int)rowIndex byExtendingSelection:(BOOL)flag
{
	return [super selectRow:[self data2table:rowIndex] byExtendingSelection:flag];
}

#if 0

// delegate's methods
- (BOOL)tableView:(NSTableView *)aTableView shouldEditTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex
- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
#endif

@end
